<?php
// In my case $HTTP_ENV_VARS['PATH'] = bin:usr/bin
$env_vars = explode( ':', $HTTP_ENV_VARS['PATH']);
// Combine the required part from $HTTP_ENV_VARS['PATH'] and convert for your path.
$env_path = $env_vars[1]."/convert";
// Now $env_path = usr/bin/convert

// If the form has been submitted do this
if ( $Submit ) {  

// Some basic error checking
if( strlen( $colour1 ) > 3 ){ echo "ERROR: Please press back on your browser"; exit; }
if( strlen( $colour2 ) > 3 ){ echo "ERROR: Please press back on your browser"; exit; }
if( strlen( $colour3 ) > 3 ){ echo "ERROR: Please press back on your browser"; exit; }

// Delete all old generated images
foreach (glob("*.png") as $filename) {
unlink($filename);
}

// Image name
$original_image = 'imagemap1.jpg';

$time =  time();
$new_image = $time.'.png';

// Temp image 
$temp_image1 = 'temp1_'.$original_image;
$temp_image1 = str_replace(jpg, png, $temp_image1); 

$temp_image2 = 'temp2_'.$original_image;

exec("$env_path $original_image -matte \( +clone -fuzz $fuzzy% -transparent rgb\($colour1,$colour2,$colour3\) \) -compose DstOut -composite $temp_image1");

exec("$env_path $original_image -colorspace Gray $temp_image2");

exec("$env_path $temp_image2 -page +0+0 $temp_image1 -flatten $new_image");

unlink($temp_image2);

echo "<img src=\"".$new_image."\">";

}
else { 

// Get the mouse location from the header
preg_match("/.+\?([0-9]+),([0-9]+)/",$_SERVER['REQUEST_URI'],$matches); 
$x = $matches[1];
$y = $matches[2];

// Create the canvas
$im = imagecreatefromjpeg('imagemap1.jpg');

// Find the colours at the locations. I am not just taking one pixel but 5 for an averidge colour.
// central pixel
$rgb = ImageColorAt( $im, $x, $y );
$r = ( $rgb >> 16 ) & 0xFF;
$g = ( $rgb >> 8 ) & 0xFF;
$b = $rgb & 0xFF;
//echo "<br> r = ".$r." g = ".$g." b = ".$b;

$rgb1 = ImageColorAt( $im, $x-5, $y );
$r1 = ( $rgb1 >> 16 ) & 0xFF;
$g1 = ( $rgb1 >> 8 ) & 0xFF;
$b1 = $rgb1 & 0xFF;
//echo "<br> r1 = ".$r1." g1 = ".$g1." b1 = ".$b1;

$rgb2 = ImageColorAt($im, $x+5, $y);
$r2 = ( $rgb2 >> 16 ) & 0xFF;
$g2 = ( $rgb2 >> 8 ) & 0xFF;
$b2 = $rgb2 & 0xFF;
//echo "<br> r2 = ".$r2." g2 = ".$g2." b2 = ".$b2;

$rgb3 = ImageColorAt( $im, $x, $y-5 );
$r3 = ( $rgb3 >> 16 ) & 0xFF;
$g3 = ( $rgb3 >> 8 ) & 0xFF;
$b3 = $rgb3 & 0xFF;
//echo "<br> r3 = ".$r3." g3 = ".$g3." b3 = ".$b3;

$rgb4 = ImageColorAt( $im, $x, $y+5 );
$r4 = ( $rgb4 >> 16 ) & 0xFF;
$g4 = ( $rgb4 >> 8 ) & 0xFF;
$b4 = $rgb4 & 0xFF;
//echo "<br> r4 = ".$r4." g4 = ".$g4." b4 = ".$b4;

$averidge_r = round(( $r + $r1 + $r2 + $r3 + $r4 )/5);
//echo "<br>".$averidge_r;

$averidge_g = round(( $g + $g1 + $g2 + $g3 + $g4 )/5);
//echo "<br>". $averidge_g;

$averidge_b = round(( $b + $b1 + $b2 + $b3 + $b4 )/5);
//echo "<br>".$averidge_b."<br>";

// Create a coloured box to show averidge colour
$time =  time();
$new_name= $time.'.png';

exec("$env_path -size 50x20 xc:none -fill rgb\($averidge_r,$averidge_g,$averidge_b\) -draw \"rectangle 0,0 50,20\" $new_name");

echo "Colour picked = <img src=\"".$new_name."\">";


?>
<p>If you are happy with these settings press submit</p>
<form method="post" action="<?php echo $PHP_SELF; ?>" enctype="multipart/form-data"> 
<input type="text" name="colour1" value="<?php echo $averidge_r ?>" size="4">
<input type="text" name="colour2" value="<?php echo $averidge_g ?>" size="4">
<input type="text" name="colour3" value="<?php echo $averidge_b ?>" size="4">
<input type="hidden" name="swatch" value="<?php echo $new_name; ?>">
<p>fuzzy percent</p>
<input type="text" name="fuzzy" size="4" value="18">
<input type="Submit" name="Submit" value="Submit" />
</form>
 <?php
 }
?>
